{
  description = "converse js";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-24.05";
    flake-utils.url = "github:numtide/flake-utils";
    disko = {
      url = "github:nix-community/disko";
      inputs.nixpkgs.follows = "nixpkgs";
    };
    sops-nix = {
      url = "github:Mic92/sops-nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = { self, nixpkgs, flake-utils, sops-nix, disko }:
    flake-utils.lib.eachDefaultSystem
      (system:
        let pkgs = nixpkgs.legacyPackages.${system};
        in {
          formatter = pkgs.nixpkgs-fmt;
          devShells = {
            default = pkgs.mkShell {
              buildInputs = with pkgs; [
              ];
            };
          };
          packages = {
						converse = pkgs.fetchFromGitHub {
							owner = "conversejs";
							repo = "converse.js";
							rev = "v10.1.7";
							hash = "sha256-kF0aS/z7D5N81xcq7o6YMqcGbSox7eafK5feC98JXIM=";
						};
						conversejs = builtins.fetchTarball {
							url = "https://github.com/conversejs/converse.js/releases/download/v10.1.7/converse.js-10.1.7.tgz";
							sha256 = "1m6jjy1hcr6wq72rw9zwn55vxi5k85835d9k047ss46rkp8wwmd1";
						};
					};
        }
      );
}
